#include "pch.h"
#include ".\SubFunc.h"
#include ".\Gpibac.h"

// ************************************************** [`FbN(f)֐] ***
long CheckRet(CString Func, long Ret, CString *csBuf)
{
	long	RetCode;
	long	RetTmp;

	RetCode = 0;						// 펞
	RetTmp = Ret & 0xff;				// }XN
	if(RetTmp >= 3){					// Ret3ȏ̏ꍇ̓G[
		RetCode = 1;					// ُ펞
		switch(RetTmp)
		{
			case 3:		*csBuf = Func + _T(" : FIFOɃf[^cĂ܂B"); 								break;	// 0x03
			case 80:	*csBuf = Func + _T(" : I/OAhXG[łB[Config.exe]ŊmFĂB"); 		break;	// 0x50
			case 82:	*csBuf = Func + _T(" : WXgݒG[łB[Config.exe]ŊmFĂB");	break;	// 0x52
			case 128:	*csBuf = Func + _T(" : Meʂ𒴂SRQMĂ܂B"); 					break;	// 0x80
			case 200:	*csBuf = Func + _T(" : Xbh쐬ł܂B"); 									break;	// 0xC8
			case 201:	*csBuf = Func + _T(" : ̃Cxgsł"); 									break;	// 0xC9
			case 210:	*csBuf = Func + _T(" : DMAݒł܂"); 											break;	// 0xD0
			case 240:	*csBuf = Func + _T(" : EscL[܂B"); 										break;	// 0xF0
			case 241:	*csBuf = Func + _T(" : t@Co̓G[łB"); 									break;	// 0xF1
			case 242:	*csBuf = Func + _T(" : AhXw肪ԈĂ܂B"); 								break;	// 0xF2
			case 243:	*csBuf = Func + _T(" : obt@wG[łB");										break;	// 0xF3
			case 244:	*csBuf = Func + _T(" : zTCYG[łB");										break;	// 0xF4 	
			case 245:	*csBuf = Func + _T(" : obt@܂B"); 										break;	// 0xF5
			case 246:	*csBuf = Func + _T(" : sȃIuWFNgłB"); 									break;	// 0xF6
			case 247:	*csBuf = Func + _T(" : foCX̉̃`FbNłB"); 							break;	// 0xF7
			case 248:	*csBuf = Func + _T(" : sȃf[^^łB"); 											break;	// 0xF8
			case 249:	*csBuf = Func + _T(" : ȏfoCXǉł܂B"); 							break;	// 0xF9
			case 250:	*csBuf = Func + _T(" : foCX܂B"); 									break;	// 0xFA
			case 251:	*csBuf = Func + _T(" : f~^foCXԂňĂ܂B"); 							break;	// 0xFB
			case 252:	*csBuf = Func + _T(" : GPIBG[łB"); 												break;	// 0xFC
			case 253:	*csBuf = Func + _T(" : f~^݂̂M܂B"); 									break;	// 0xFD
			case 254:	*csBuf = Func + _T(" : ^CAEg܂B"); 										break;	// 0xFE
			case 255:	*csBuf = Func + _T(" : p[^G[łB"); 										break;	// 0xFF
		}
	}else{
		*csBuf = Func + _T(" : I܂B");
	}

	// -- [Ifc] [Srq] M̏ -- //
    RetTmp = Ret & 0xff00;	// }XN
	switch(RetTmp)
	{
		case 0x100:		*csBuf = *csBuf + _T(" -- [SRQ]M<STATUS>");		break;	// 256(10)
		case 0x200:		*csBuf = *csBuf + _T(" -- [IFC]M<STATUS>");		break;	// 512(10)
		case 0x300:		*csBuf = *csBuf + _T(" -- [SRQ][IFC]M<STATUS>");	break;	// 768(10)
	}
	return	RetCode;
}

//************************************************************ [ׂ֐] ***
int Pows(int x, int y)
{
	int tmp = 1;

	while (y-- > 0)										// y ̉񐔕JԂ܂B
		tmp *= x;										// tmp  x |Ă܂B
	return(tmp);
}

//****************************************************** [ -> 16i] ***
DWORD chr2hex(TCHAR* ch)
{
	long	length;
	long 	Count;
	long	Ret;
	long	RetTmp;

	RetTmp = 0;
	length	= lstrlen(ch);								// 𒲂ׂ܂B
	for(Count = 0;Count < length ;Count++){				// JԂ܂B
		if((ch[Count] >= 0x30) && (ch[Count] <=0x39))	// ASCIIR[h琔IȒl擾	
		  Ret = (ch[Count] - 0x30) * Pows(0x10,(length - (Count + 1)));	// 0 - 9 
		else if((ch[Count] >= 0x41) && (ch[Count] <= 0x46))
		  Ret = (ch[Count] - 0x37) * Pows(0x10,(length - (Count + 1)));	// A - F 
		else if((ch[Count] >= 0x61) && (ch[Count] <= 0x66))
		  Ret = (ch[Count] - 0x57) * Pows(0x10,(length - (Count + 1)));	// a - f 
		else
		  Ret = 0xff;									// sȏꍇFF(255)Ԃ܂B
	
		RetTmp = RetTmp + Ret;
	}
	return RetTmp;
}

//************************************************************ [֐] ***
long GpibInit(CString *TextRet)
{
//	int		Delim,Eoi;
	int		Timeout,Ifctime,Ret;	
	CString	csBuf;
	DWORD	Master;


	Ret = GpExit();										// 2dh܂B
	Ret = GpIni();										// GPIB܂B
	csBuf = _T("GpIni");

	if((Ret & 0xFF) != 0){								// GpIniɍs`FbNB
		CheckRet(_T("GpIni"), Ret, &csBuf);
		*TextRet = csBuf;
		return	1;
	}

	GpBoardsts(0x0a, &Master);							// }X^̃AhX擾܂B
	// }X^AX[u̔
	if(Master == 0){
		Ifctime = 1;									// ł100secɂĂ܂B
		Ret = GpIfc(Ifctime);
		csBuf = _T("GpIfc");
		if((Ret & 0xFF) != 0){							// GpIfcɍs`FbNB
			CheckRet(_T("GpIfc"), Ret, &csBuf);
			*TextRet = csBuf;
			return	1;
		}
		Ret = GpRen();
		csBuf = _T("GpRen");
		if((Ret & 0xFF) != 0){							// GpRenɍs`FbNB
			CheckRet(_T("GpRen"), Ret, &csBuf);
			*TextRet = csBuf;
			return	1;
		}
	}

	/*Delim = 1;										// f~^FCR+LF
	Eoi = 1;											// EOI     Fgp
	Ret = GpDelim(Delim, Eoi);
	csBuf = "GpDelim";
	if((Ret & 0xFF) != 0){								// GpDelimɍs`FbNB
		CheckRet("GpDelim", Ret, &csBuf);
		*TextRet = csBuf;
		return	1;
	}*/
	Timeout = 10000;									// 10b
	Ret = GpTimeout(Timeout);
	csBuf = _T("GpTimeout");
	if((Ret & 0xFF) != 0){								// GpTimeoutɍs`FbNB
		*TextRet = csBuf;
		CheckRet(_T("GpTimeout"), Ret, &csBuf);
		return	1;
	}

	*TextRet = _T("܂B");			// I
	return	0;
}

//******************************************************** [GpTalk()̉p] ***
long GpibPrint(long DevAddr, CString Str)
{
	char	srbuf[10000];								// M
	TCHAR	szbuf[10000];
	DWORD	MyAddr, Cmd[16];							// }CAhXAR}hp
	CString	ErrText;									// G[
	long	Ret, RetTmp, srlen;							// ߂lA\߂lA̒

	Ret = GpBoardsts(0x08, &MyAddr);					// }CAhX擾
	Cmd[0] = 2;											// R}h̐
	Cmd[1] = MyAddr;									// }CAhX(PC)
	Cmd[2] = DevAddr;									// X[u@

	srlen = lstrlen(Str);								// 𑪒
	lstrcpy(szbuf, Str);								// CString -> TCHAR
#ifdef _UNICODE
	sprintf_s(srbuf, srlen + 1, "%S", szbuf);			// TCHAR   -> char
#else
	strcpy_s(srbuf, sizeof(srbuf), szbuf);				// HIOKIҏW(MBCSΉ)
#endif
    Ret = GpTalk(Cmd, srlen, (UCHAR*)srbuf);			// ۂ̑M

	if (Ret >= 3){										// G[`FbN
		RetTmp = CheckRet(_T("GpTalk"), Ret, &ErrText);
		ErrText += _T(" p܂H");
		Ret = AfxMessageBox(ErrText, MB_YESNO);
		if (Ret == IDNO) return 1;						// ُ
	}
	return 0;											// 
}

//****************************************************** [GpListen()̉p] ***
long GpibInput(long DevAddr, CString *Str)
{
	BYTE	srbuf[10000];								// Mf[^10000傫ꍇ͒lύXĉB
	DWORD	MyAddr,srlen, Cmd[16];						// }CAhXA̒AR}hp
	CString	TmpStr, ErrText;							// \AG[
	long	Ret, RetTmp;								// ߂lA\߂l

   	memset( srbuf, '\0', 10000 );						// 

    Ret = GpBoardsts(0x08, &MyAddr);					// }CAhX擾
	Cmd[0] = 2;											// R}h̐
	Cmd[1] = DevAddr;									// X[u@
	Cmd[2] = MyAddr;									// }CAhX(PC)
	srlen = sizeof(srbuf);								// Mf[^̒𑪂Ă܂B
    Ret = GpListen(Cmd, &srlen, srbuf);					// ۂ̑M
	if (Ret >= 3){										// G[`FbN
		RetTmp = CheckRet(_T("GpListen"), Ret, &ErrText);
		ErrText += _T(" p܂H");
		Ret = AfxMessageBox(ErrText, MB_YESNO);
		if (Ret == IDNO) return 1;						// ُ = 1Ԃ
	}
	*Str = srbuf;
	return 0;											//  = 0Ԃ
}

//HIOKIǉ
//****************************************************** [GpListen()̉p] ***
long GpibInputHioki(long DevAddr, CString *Str)
{
	BYTE	Srbuf[10000];								// ̃obt@
	DWORD	Srlen;										// ̒
	DWORD	MyAddr;										// }CAhX
	DWORD	Cmd[16];									// bZ[W(R}h)
	CString	ErrText;									// G[
	long	Ret;										// ߂l

	Ret = GpBoardsts(0x08, &MyAddr);					// }CAhX擾
	Cmd[0] = 2;											// R}h̐
	Cmd[1] = DevAddr;									// X[u@
	Cmd[2] = MyAddr;									// }CAhX(PC)

	*Str = "";											// 
	while (true){
		Srlen = sizeof(Srbuf) - 1;						// őM
		Ret = GpListen(Cmd, &Srlen, Srbuf);
		if (Ret <= 2){									// MI
			Srbuf[Srlen] = '\0';
			CString Srtmp(Srbuf);
			*Str += Srtmp;
			break;
		}
		else if (Ret == 128){							// Mf[^I[o[
			Srbuf[Srlen] = '\0';
			CString Srtmp(Srbuf);
			*Str += Srtmp;
			Cmd[0] = 0;									// R}hoGpListen܂B
		}
		else{
			CheckRet(_T("GpListen"), Ret, &ErrText);
			Ret = AfxMessageBox(ErrText, MB_OK);
			return 1;									// ُ = 1Ԃ
		}
	}
	return 0;											//  = 0Ԃ
}

// ************************************************* [ oCiMp֐ ] ***
long GpibInputB(long DevAddr, BYTE *IntData)
{
	BYTE	szData[10000];
	DWORD	Ret, RetTmp, MyAddr, Cmd[8], srlen;
	CString	ErrText = _T("");

	memset(szData, '\0', 10000);

	Ret = GpDelim(0, 1);								// f~^𑊎@ƍ킹܂B
    Ret = GpBoardsts(0x08, &MyAddr);					// }CAhX擾
	Cmd[0] = 2;											// R}h̐
	Cmd[1] = DevAddr;									// X[u@
	Cmd[2] = MyAddr;									// }CAhX(PC)
	srlen = 2;											// Mf[^̒𑪂Ă܂B
	Ret = GpListen(Cmd, &srlen, szData);
	if (Ret != 128){									// rŃf[^؂Ă邽Ret=128ɂȂ܂B
		if (Ret >= 3){									// G[`FbN
			RetTmp = CheckRet(_T("GpListen"), Ret, &ErrText);
			ErrText += _T(" p܂H");
			Ret = AfxMessageBox(ErrText, MB_YESNO);
			if (Ret == IDNO) return 1;					// ُ = 1Ԃ
		}
	}
	Cmd[0] = 0;
	srlen = _ttoi((LPCTSTR)&szData[1]);
	Ret = GpListen(Cmd, &srlen, szData);
	srlen = (_ttoi((LPCTSTR)&szData)) + 1;
	Ret = GpListen(Cmd, &srlen, IntData);

	Ret = GpDelim(3, 1);								// f~^߂܂B
	return 0;
}

//****************************************************** [R}hM֐] ***
long GpibCommand(long DevAddr)
{
	DWORD	Cmd[16];
	CString	ErrText;
	long	Ret, RetTmp;

	Cmd[0] = 2;
	Cmd[1] = 0x3F;
	Cmd[2] = 0x5F;

	Ret = GpComand(Cmd);

	if (Ret != 0){
		RetTmp = CheckRet(_T("GpComand"), Ret, &ErrText);
		AfxMessageBox(ErrText, MB_OK);
		return 1;
	}
	return 0;
}

//**************************************************************** [I֐] ***
void GpibExit()
{
	DWORD	Master, Cmd[16];
	long	Ret;

	Ret = GpBoardsts(0x0a, &Master);					// }X^̃AhX擾܂B
	if(Ret == 80) return;								// ĂȂꍇɖ߂܂B
	
	if(Master == 0){									// }X^̏ꍇ
		Cmd[0] = 2;										// R}h(bZ[W)
		Cmd[1] = 0x3f;									// AX(Xi)
		Cmd[2] = 0x5f;									// Ag[N(g[J)
		Ret = GpComand(Cmd);							// R}h𑗐M܂B
	}
		Ret = GpResetren();								// @̃[g܂B
	
	Ret = GpExit();
}

// OPC̃`FbN ////////////////////////////////////////////////////////////////////////////////
void WaitOPC(long Dev)
{
	long	Ret;
	CString RdData;

	Ret = GpibPrint(Dev, _T("*OPC?"));					// HƂĂ邩
	Ret = GpibInput(Dev, &RdData);
}

//**************************************************** [𐔎ɕϊ] ***
void Str2Num(char *str, DWORD str_len, int *num, DWORD num_len)
{
	DWORD i, cnt;
	char *start;

	start = str;
	cnt = 0;
	for (i=0; i<str_len; i++) {
		/* string to integer */
		if (str[i] == ',') {
			str[i] = '\0';
			num[cnt] = atoi(start);
			str[i] = ',';
			start = &str[i+1];
			cnt++;
			if (cnt >= num_len) break;
		}
	}
	if (cnt >= num_len) {
		num[cnt] = atoi(start);
	}
}

//********************************************************** [Ot`] ***
// QŃOtpsN`[_CAOgpĂ܂B
void DrawGraph(HWND hDlg, DWORD Picture, int *num, DWORD num_len, int min, int max)
{
	HWND	Disp_handle;
	RECT	Rect;
	HDC		hDC;
	HPEN	hPen_Black, hPen_Red, hPen_White;
	HBRUSH	hBrush1, hBrush2, hBrush3;
	POINT	Point[4];
	int		x_max, y_max;
	int		x_width, y_width;
	float	x_unit, y_unit;
	DWORD	i;

	/* Initialize */
	Disp_handle = GetDlgItem(hDlg, Picture);
	GetClientRect(Disp_handle, &Rect);
	x_max = Rect.right;
	y_max = Rect.bottom;
	hDC = GetDC(Disp_handle);

	hPen_Black = CreatePen(PS_SOLID, 1, RGB(0, 0, 0));		/* Black */
	hPen_Red   = CreatePen(PS_SOLID, 1, RGB(255, 0, 0));	/* Red   */
	hPen_White = CreatePen(PS_SOLID, 1, RGB(255, 255, 255));/* White */	
	/* Draw Structure */
	hBrush3 = (HBRUSH)SelectObject(hDC, hPen_White);
	Rectangle(hDC, Rect.left, Rect.top, Rect.right, Rect.bottom);
	hBrush1 = (HBRUSH)SelectObject(hDC, hPen_Black);
	for (i=0; i<=10; i++) {
		MoveToEx(hDC, (x_max / 10) * i, 0, NULL);
		LineTo(  hDC, (x_max / 10) * i, y_max);
	}
	for (i=0; i<=10; i++) {
		MoveToEx(hDC, 0,   (y_max / 10) * i, NULL);
		LineTo(hDC, x_max, (y_max / 10) * i);
	}
	hBrush2 = (HBRUSH)SelectObject(hDC, hPen_Red);
	Point[0].x = (x_max / 10) * 5 - 1; Point[0].y = 0;
	Point[1].x = (x_max / 10) * 5 + 1; Point[1].y = 0;
	Point[2].x = (x_max / 10) * 5 + 1; Point[2].y = y_max;
	Point[3].x = (x_max / 10) * 5 - 1; Point[3].y = y_max;
	Polyline(hDC, &Point[0], 4);
	Point[0].x = 0;     Point[0].y = (y_max / 10) * 5 - 1;
	Point[1].x = 0;     Point[1].y = (y_max / 10) * 5 + 1;
	Point[2].x = x_max; Point[2].y = (y_max / 10) * 5 + 1;
	Point[3].x = x_max; Point[3].y = (y_max / 10) * 5 - 1;
	Polyline(hDC, &Point[0], 4);
	/* Draw Graph */
	hBrush1 = (HBRUSH)SelectObject(hDC, hPen_Black);
	x_width = num_len;
	y_width = max - min;
	x_unit = (float)((float)x_max / (float)x_width);
	y_unit = (float)((float)y_max / (float)y_width);
	for (i=0; i<num_len-1; i++) {
		MoveToEx(hDC, (int)(x_unit * i)      , (int)((y_width - (num[i] - min)) * y_unit) , NULL);
		LineTo(  hDC, (int)(x_unit * (i + 1)), (int)((y_width - (num[i+1] - min)) * y_unit));
	}
	/* ending */
	SelectObject(hDC, hBrush1);
	DeleteObject(hPen_Black);
	SelectObject(hDC, hBrush2);
	DeleteObject(hPen_Red);
	SelectObject(hDC, hBrush3);
	DeleteObject(hPen_White);
	ReleaseDC(Disp_handle, hDC);
}


